<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Doctor extends Model 
{

    protected $table = 'doctors';
    public $timestamps = true;
    protected $fillable = array('name');

    public function clinics()
    {
        return $this->belongsToMany('Clinic');
    }

    public function appointments()
    {
        return $this->hasMany('Appointment', 'doctor_id');
    }

}